/*1357223000,178142525*/

if (self.CavalryLogger) { CavalryLogger.start_js(["48vAQ"]); }

/** js/presence/beeper.js */

























function Beeper(a){
this._baseRoot=a;
this._notifSound=null;

if(!FbDesktopPlugin.shouldSuppressBeeper()){

this._receiver=new LiveMessageReceiver(Beeper.BEEP_EVENT).
setAppId(Notifications.BEEPER_APPID).
setHandler(this.fromMessage.bind(this)).
register();



Arbiter.subscribe
(ChannelConstants.getArbiterType('notif_sound_pref_changed'),
function(b,c){
this.receiveSoundEnabled=c.obj.enabled;}.
bind(this));}}




copyProperties(Beeper,

{BEEP_EVENT:'beep_event',
CONTENT_ID:'BeeperBox',



DEFAULT_DELAY_MS:10000,
DEFAULT_UNPAUSE_MS:500,
SLIDE_DOWN_ANIMATION_MS:700,
FADE_IN_ANIMATION_MS:500,
FADE_OUT_ANIMATION_MS:1250,

_instance:null,

setInstance:function(a){
Beeper._instance=a;},


getInstance:function(){
Beeper.ensureInitialized();
return Beeper._instance;},


ensureInitialized:function(){
if(!Beeper._instance)
Beeper.setInstance
(new Beeper($(Beeper.CONTENT_ID)));},




setParams:function(a){
if(!Beeper._instance)
return;

Beeper._instance.receiveSoundPath=a.receiveSoundPath||null;
Beeper._instance.receiveSoundEnabled=a.receiveSoundEnabled||false;}});



copyProperties(Beeper.prototype,

{beeps:null,
beepId:0,







checkBeepsMap:function(){
if(!this.beeps&&window.DoublyLinkedListMap)
this.beeps=new DoublyLinkedListMap();

return this.beeps;},





reset:function(){
if(this.checkBeepsMap())
this.beeps.reset();


this.beepId=0;

if(this._root)
DOM.remove(this._root);

this._root=$(this._baseRoot.cloneNode(true));
Event.listen(this._root,'mouseover',this.mouseover.bind(this));
Event.listen(this._root,'mouseout',this.mouseout.bind(this));
DOM.insertAfter(this._baseRoot,this._root);

this._full=DOM.find(this._root,'div.UIBeeper_Full');
this._inside=DOM.find(this._root,'div.Beeps');

if(this._timer)
clearInterval(this._timer);

this._timer=null;
this._animation=null;
this._paused=0;

Arbiter.inform(Notifications.BEEPS_EXPIRED);},


mouseover:function(event){
this.pause();
this.markRead(true);},


mouseout:function(event){
this.unpause();},


fromMessage:function(a){

if(!this._root)
this.reset();

var b=new Beep(this,a);
this.addBeep(b);},









addBeep:function(a){
if(!this.checkBeepsMap())
return;



a.beepId=a.alertId;
if(this.beeps.exists(a.beepId))
this.beeps.get(a.beepId).remove();

this.beeps.append(a.beepId,a);

a.setTop(true);

if(this.beeps.getCount()==1){
a.setBottom(true);
CSS.show(this._root);}else{

a.setBottom(false);
this.beeps.getPrev(this.beeps.getTail().beepId).setTop(false);}


if(this.receiveSoundEnabled&&a.sound){
if(this._notifSound===null)
this._notifSound=new NotificationSound(this.receiveSoundPath);




var b=a.alertId+':'+a.alert.time_created;
this._notifSound.play(b);}


this._restartTimer(Beeper.DEFAULT_DELAY_MS);
DOM.prependContent(this._inside,a.getNode());
ARIA.notify(DOM.getText(a.getNode()));
a.fadeIn(Beeper.FADE_IN_ANIMATION_MS);
a.type=='NotificationBeep'&&
window.presenceNotifications&&
presenceNotifications.logImpressionIds
([a.alertId],
presenceNotifications.BEEPER_REF);},









expireBeeps:function(){
if(!this.checkBeepsMap()||this.beeps.isEmpty())
return;


this.fadeOut();},





fadeOut:function(){
this._animation=
animation(this._full).
duration(Beeper.FADE_OUT_ANIMATION_MS).
to('opacity',0).
blind().
ease(animation.ease.begin).
ondone(function(){
this.reset();}.
bind(this));

this._animation.undo=function(){
this._animation.stop();
Style.set(this._full,'opacity',1);}.
bind(this);

this._animation.go();},












markRead:function(a,b){
if(!this.checkBeepsMap())
return;



if(!b){
b=[];
this.beeps.map(function(d){
if(d.unread&&
d.type=='NotificationBeep')
b.push(d.alertId);});}






var c=createObjectFrom(b);
this.beeps.map(function(d){
if(c[d.alertId])
d.markRead();});





if(a&&b.length)
window.presenceNotifications&&
presenceNotifications.markRead(true,b);},






pause:function(){
if(this._animation&&this._animation.undo){
this._animation.undo();
this._animation=null;







return;}


this._pauseTimer();
CSS.addClass(this._root,'UIBeeper_Paused');
this._paused++;},


_pauseTimer:function(){
if(this._timer)
clearInterval(this._timer);},






unpause:function(a){
if(!a)
a=Beeper.DEFAULT_UNPAUSE_MS;










this._paused--;
if(this._paused<=0){
CSS.removeClass(this._root,'UIBeeper_Paused');
this._restartTimer(a);}},



_restartTimer:function(a){
if(this._animation&&this._animation.undo)
this._animation.undo();

if(this._timer)
clearInterval(this._timer);

this._timer=this.expireBeeps.bind(this).defer(a,false);},





updateEdges:function(){
if(!this.checkBeepsMap()||this.beeps.isEmpty())
return;


this.beeps.getHead().setBottom(true);
this.beeps.getTail().setTop(true);}});
